/*
 * Decompiled with CFR 0.152.
 */
package com.nick.chimes;

import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraftforge.common.ForgeConfigSpec;

public class ChimesClientConfig {
    private static final Path CONFIG_PATH = Paths.get("config", "chimes.toml");
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.ConfigValue<Boolean> ANIMATIONS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> BAMBOOLEAN;
    public static final ForgeConfigSpec.ConfigValue<Boolean> AMBIENTWIND;
    public static final ForgeConfigSpec.DoubleValue WIND_CHIME_AMBIENT_VOL;
    public static final ForgeConfigSpec.DoubleValue WIND_CHIME_INTERACT_VOL;
    public static final ForgeConfigSpec SPEC;

    public Boolean setAnimation(boolean possible) {
        return (Boolean)ANIMATIONS.get() == possible;
    }

    public Boolean getAnimation() {
        return (Boolean)ANIMATIONS.get();
    }

    public Boolean setNewBambooTextures(boolean possible) {
        return (Boolean)BAMBOOLEAN.get() == possible;
    }

    public Double setAmbientVolume() {
        return (Double)WIND_CHIME_AMBIENT_VOL.get();
    }

    public Double setInterationVolume() {
        return (Double)WIND_CHIME_INTERACT_VOL.get();
    }

    public void save() {
        SPEC.save();
    }

    static {
        BUILDER.push("Chimes Config");
        ANIMATIONS = BUILDER.comment("Toggle Wind Chime Animations").define("Animations", true);
        BAMBOOLEAN = BUILDER.comment("Toggle falling Bamboo Leaf particles from Bamboo Wind Chimes").define("Bamboo Wind Chime Leaf Particles", true);
        AMBIENTWIND = BUILDER.comment("Toggle Ambient Wind sounds that Wind Chimes make").define("Ambient Wind", true);
        WIND_CHIME_AMBIENT_VOL = BUILDER.comment("Adjust the volume of ambient Wind Chime Sounds.").defineInRange("Ambient Wind Chime Sound Volume", 1.0, 0.0, 1.0);
        WIND_CHIME_INTERACT_VOL = BUILDER.comment("Adjust the volume of interaction Wind Chime Sounds.").defineInRange("Interaction Wind Chime Sound Volume", 1.0, 0.0, 1.0);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

